<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content py-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="card shadow-sm mb-3">
    <div class="card-body d-flex justify-content-between align-items-center">
        <h6 class="fw-bold mb-0"><i class="material-icons fs-6">event_busy</i> Hari Libur</h6>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">+ Tambah Hari Libur</button>
    </div>
</div>


                        <div class="mt-3 text-end">
                <a href="<?= base_url('admin/menuseting') ?>" 
                   class="btn btn-primary w-100" 
                   style="background-color: #f41848; border-color: #b144ff; color: #fff;">
                    <i class="material-icons">arrow_back</i> Kembali
                </a>
            </div>

<!-- ================= TABLE ================= -->
<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="tableHariLibur">
                <thead class="table-primary">
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Keterangan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

</div>
</div>

<!-- ================= MODAL TAMBAH ================= -->
<div class="modal fade" id="modalTambah" tabindex="-1">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Tambah Hari Libur</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<form id="formTambah">
    <div class="mb-3">
        <label>Tanggal</label>
        <input type="date" name="tanggal" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Keterangan</label>
        <input type="text" name="keterangan" class="form-control" required>
    </div>
    <button type="submit" class="btn btn-primary">Simpan</button>
</form>
</div>
</div>
</div>
</div>

<!-- ================= JS AJAX ================= -->
<script>
// ================= LOAD DATA =================
function loadData(){
    fetch('<?= base_url("admin/harilibur/list") ?>')
    .then(res => res.json())
    .then(data => {
        let tbody = '';
        data.forEach((h,i)=>{
            tbody += `<tr data-id="${h.id_libur}">
                <td>${i+1}</td>
                <td class="editable" data-field="tanggal">${h.tanggal}</td>
                <td class="editable" data-field="keterangan">${h.keterangan}</td>
                <td>
                    <button class="btn btn-sm btn-danger" onclick="hapus(${h.id_libur})">Hapus</button>
                </td>
            </tr>`;
        });
        document.querySelector('#tableHariLibur tbody').innerHTML = tbody;
        makeEditable();
    });
}

// ================= EDITABLE INLINE =================
function makeEditable(){
    document.querySelectorAll('#tableHariLibur td.editable').forEach(td=>{
        td.onclick = function(){
            if(this.querySelector('input')) return; // Sudah ada input

            const current = this.textContent;
            const field = this.dataset.field;
            const tr = this.closest('tr');
            const id = tr.dataset.id;

            this.innerHTML = `<input type="text" class="form-control form-control-sm" value="${current}">`;
            const input = this.querySelector('input');
            input.focus();

            input.onblur = () => saveInline(id, field, input.value, td);
            input.onkeypress = e => {
                if(e.key==='Enter') input.blur();
            }
        }
    });
}

// ================= SAVE INLINE =================
function saveInline(id, field, value, td){
    const formData = new FormData();
    formData.append(field, value);

    fetch('<?= base_url("admin/harilibur/update") ?>/'+id,{
        method:'POST',
        body: formData
    })
    .then(res=>res.json())
    .then(res=>{
        alert(res.msg);
        if(res.status) td.textContent = value;
        else td.textContent = td.dataset.original || value;
    });
}

// ================= TAMBAH =================
document.querySelector('#formTambah').addEventListener('submit',function(e){
    e.preventDefault();
    let data = new FormData(this);
    fetch('<?= base_url("admin/harilibur/add") ?>',{
        method:'POST',
        body:data
    })
    .then(res=>res.json())
    .then(res=>{
        alert(res.msg);
        if(res.status){
            this.reset();
            bootstrap.Modal.getInstance(document.getElementById('modalTambah')).hide();
            loadData();
        }
    });
});

// ================= HAPUS =================
function hapus(id){
    if(!confirm('Hapus hari libur ini?')) return;
    fetch('<?= base_url("admin/harilibur/delete") ?>/'+id)
    .then(()=>loadData());
}

// ================= INIT =================
window.addEventListener('DOMContentLoaded', loadData);
</script>

<?= $this->endSection() ?>
